using System;
using System.Windows.Forms;
using System.CodeDom;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Gui;
using BeWise.SharpBuilderTools.Utils;
using BeWise.SharpBuilderTools.Helpers;

namespace BeWise.SharpBuilderTools
{
	public class OTAMenuEnhancement : BaseOTA
	{
		/**************************************************************/
		/*                        Protected
		/**************************************************************/

		protected void DoGoToNextError(object aSender, EventArgs AEventArgs)
		{
			IOTAMessageService _MessageService = (IOTAMessageService) BorlandIDE.GetService(typeof(IOTAMessageService));

			_MessageService.NextErrorMessage(true, true);
		}

		protected void DoGoToPreviousError(object aSender, EventArgs AEventArgs)
		{
			IOTAMessageService _MessageService = (IOTAMessageService) BorlandIDE.GetService(typeof(IOTAMessageService));

			_MessageService.NextErrorMessage(false, true);
		}

		protected void DoUpperCase(object aSender, EventArgs AEventArgs)
		{
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			IOTAEditView _EditView = _SourceEditor.GetEditView(0);

			_EditView.Buffer.EditBlock.UpperCase();
			_EditView.Paint();
		}

		protected void DoLowerCase(object aSender, EventArgs AEventArgs)
		{
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			if (_SourceEditor != null && _SourceEditor.EditViewCount > 0) {
				IOTAEditView _EditView =  _SourceEditor.GetEditView(0);

				_EditView.Buffer.EditBlock.LowerCase();
				_EditView.Paint();
			}
		}

		protected void DoIndent(object aSender, EventArgs AEventArgs)
		{
		IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

		if (_SourceEditor != null && _SourceEditor.EditViewCount > 0) {
			IOTAEditView _EditView = _SourceEditor.GetEditView(0);

			// TODO : Use _EditView.Buffer.EditOptions when implemented
			//_EditView.Buffer.EditBlock.Indent(_EditView.Buffer.EditOptions.BlockIndent);
			_EditView.Buffer.EditBlock.Indent(4);
			_EditView.Paint();
		}
		}

		protected void DoUnindent(object aSender, EventArgs AEventArgs)
		{
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			if (_SourceEditor != null && _SourceEditor.EditViewCount > 0) {
				IOTAEditView _EditView = _SourceEditor.GetEditView(0);

				// TODO : Use _EditView.Buffer.EditOptions when implemented
				//_EditView.Buffer.EditBlock.Indent(0 - _EditView.Buffer.EditOptions.BlockIndent);
				_EditView.Buffer.EditBlock.Indent(- 4);
				_EditView.Paint();
			}
		}

		protected void DoToggleCase(object aSender, EventArgs AEventArgs)
		{
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			if (_SourceEditor != null && _SourceEditor.EditViewCount > 0) {
				IOTAEditView _EditView = _SourceEditor.GetEditView(0);

				_EditView.Buffer.EditBlock.ToggleCase();
				_EditView.Paint();
			}
		}

		protected void DoComment(object aSender, EventArgs AEventArgs) {
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			if (_SourceEditor != null) {
				string _Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());

				if (_Text == null || _Text.Length == 0) {
					OTAUtils.SelectLine(OTAUtils.GetCurrentSourceEditor());
					_Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());
				}

				string[]  _Lines = OTAUtils.GetLinesFromString(_Text);

				// Add the Comment
				_Lines[0] = "/*" + _Lines[0];
				_Lines[_Lines.Length -1] = _Lines[_Lines.Length -1] + "*/";

				_Text = OTAUtils.BuildLines(_Lines, true);
				OTAUtils.ReplaceSelectedText(_SourceEditor, _Text);

				_SourceEditor.GetEditView(0).Paint();
			}
		}

		protected void DoUnComment(object aSender, EventArgs AEventArgs) {
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			if (_SourceEditor != null) {
				string _Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());

				if (_Text == null || _Text.Length == 0) {
					OTAUtils.SelectLine(OTAUtils.GetCurrentSourceEditor());
					_Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());
				}

				string[] _Lines = OTAUtils.GetLinesFromString(_Text);

				// Do UnComment
				if (_Lines[0].StartsWith("/*") && _Lines[_Lines.Length-1].EndsWith("*/")) {
					_Lines[0] = _Lines[0].Substring(2);
					_Lines[_Lines.Length -1] = _Lines[_Lines.Length -1].Substring(0, _Lines[_Lines.Length -1].Length -2);
				}


				_Text = OTAUtils.BuildLines(_Lines, true);
				OTAUtils.ReplaceSelectedText(_SourceEditor, _Text);
				_SourceEditor.GetEditView(0).Paint();
			}
		}

		protected void DoCreateRegion(object aSender, EventArgs AEventArgs) {
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());
			IOTAEditView _EditView = _SourceEditor.GetEditView(0);

			if (_SourceEditor != null) {
				FrmCreateRegion _Frm = new FrmCreateRegion();

				if (_Frm.ShowDialog() == DialogResult.OK) {
					string _Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());

					if (_Text == null || _Text.Length == 0) {
						OTAUtils.SelectLine(OTAUtils.GetCurrentSourceEditor());
						_Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());
					}

					string[] _Lines = OTAUtils.GetLinesFromString(_Text);
					string[] _NewLines = new string[_Lines.Length + 2];

					if (_EditView.CursorPos.Col > 1) {
						_NewLines[0] = new String(' ', _EditView.CursorPos.Col) + "#region " + _Frm.RegionText;
					}
					else  {
						_NewLines[0] = OTAUtils.GetStringBeforeFirstWord() + "#region " + _Frm.RegionText;
					}

					for (int i = 0; i < _Lines.Length; i++) {
						_NewLines[i+1] = _Lines[i];
					}

					if (_EditView.CursorPos.Col > 1) {
						_NewLines[_NewLines.Length -1] = new String(' ', _EditView.CursorPos.Col) + "#endregion";
					}
					else  {
						_NewLines[_NewLines.Length -1] = OTAUtils.GetStringBeforeFirstWord() + "#endregion";
					}

					_Text = OTAUtils.BuildLines(_NewLines, true);
					OTAUtils.ReplaceSelectedText(_SourceEditor, _Text);
					_EditView.Paint();
				}
			}
		}

		protected void DoSort(object aSender, EventArgs AEventArgs) {
			IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(OTAUtils.GetCurrentModule());

			if (_SourceEditor != null) {

				FrmSortOptions _Frm = new FrmSortOptions();

				if (_Frm.ShowDialog() == DialogResult.OK) {
					string _Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());

					if (_Text == null || _Text.Length == 0) {
						OTAUtils.SelectLine(OTAUtils.GetCurrentSourceEditor());
						_Text = OTAUtils.GetSelectedText(OTAUtils.GetCurrentModule());
					}

					string[]  _Lines = OTAUtils.GetLinesFromString(_Text);

                    // Do the sorting
					SortHelper _SortHelper = new SortHelper();
					_SortHelper.Ascending = _Frm.Ascending;
                    _SortHelper.CaseSensitive = _Frm.CaseSensitive;

					ArrayList _List = new ArrayList();
					_List.AddRange(_Lines);
					_List.Sort(_SortHelper);

					_Text = OTAUtils.BuildLines((string[]) _List.ToArray(typeof(string)), true);
					OTAUtils.ReplaceSelectedText(_SourceEditor, _Text);
					_SourceEditor.GetEditView(0).Paint();
				}
			}
		}

		protected void DoPasteCommented(object aSender, EventArgs AEventArgs) {

			IOTAEditView _EditView = OTAUtils.GetCurrentEditView();

			if (_EditView != null) {
				IDataObject _Data = Clipboard.GetDataObject();

				if (_Data.GetDataPresent(DataFormats.Text))
				{
					string _Text = _Data.GetData(DataFormats.Text).ToString();
					_Text = "/*\n" + _Text + "\n*//";
					Clipboard.SetDataObject(_Text);
					_EditView.Position.Paste();
				}
			}
		}

		/**************************************************************/
		/*                         Public
		/**************************************************************/

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

			// Next Error
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												OTAMenuItemLocation.otamlChild,
												"GoToNextErrorMenu",
												"Goto to Next Error");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoGoToNextError);

			// Previous Error
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "GoToPreviousErrorMenu",
												 "Goto to Previous Error");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoGoToPreviousError);

			// Sep1
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												OTAMenuItemLocation.otamlChild,
												"SepMenuEnhancement1",
												"-");

			// UpCase
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "UpCaseCaseMenu",
												 "Up Case");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoUpperCase);

			// Low Case
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												OTAMenuItemLocation.otamlChild,
												"LowCaseMenu",
												"Low Case");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoLowerCase);

			// Low Case
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ToggleCaseMenu",
												 "Toggle case");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoLowerCase);

			// Comment
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "CommentMenu",
												 "Comment");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoComment);

			// UnComment
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "UnCommentMenu",
												 "UnComment");
			_MenuItem.Enabled = true;
			_MenuItem.Visible = true;
			_MenuItem.Executed += new EventHandler(DoUnComment);

			// Sort
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "SortMenu",
												 "Sort...");
			_MenuItem.Enabled = true;
			_MenuItem.Visible = true;
			_MenuItem.Executed += new EventHandler(DoSort);

			// CreateRegion
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "CreateRegionMenu",
												 "Create Region...");
			_MenuItem.Enabled = true;
			_MenuItem.Visible = true;
			_MenuItem.Executed += new EventHandler(DoCreateRegion);

			// Paste Commented code
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "PasteCommentedMenu",
												 "Paste Commented");
			_MenuItem.Enabled = true;
			_MenuItem.Visible = true;
			_MenuItem.Executed += new EventHandler(DoPasteCommented);

			// Indent
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "IndentMenu",
												 "Indent");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoIndent);

			// Unindent
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "UnindentMenu",
												 "Unindent");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoUnindent);

			// Sep2
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "SepMenuEnhancement2",
												 "-");

			aMenuNames = new string[] {"GoToNextErrorMenu", "GoToPreviousErrorMenu", "UpCaseCaseMenu", "LowCaseCaseMenu", "ToggleCaseMenu",
									   "CommentMenu", "UnCommentMenu", "SortMenu", "CreateRegionMenu", "PasteCommentedMenu", "IndentMenu", "UnindentMenu"};
			aMenuShortCuts = new int[] {49221, 49232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; // Ctrl Alt E, Ctrl Alt P

			// ctr U, ctrl shift u   - > upcase, low case
		}
	}
}
